<?xml version="1.0" encoding="UTF-8"?>
<!-- El objetivo de este archivo SLD, es el de simbolizar la entidad urbanística correspondiente según lo indicado en la "Instrucción técnica de estandarización y normalización de instrumentos de planeamiento (ITU-PL1)". Antes de su uso deberá revisar las etiquetas que hacen referencia a los campos existentes en las tablas de datos, especialmente los destinados a simbolizar por categorías, los de elementos alfanuméricos y los de geometría. Su definición puede admitir variantes y ser mejorada. Si es el caso, por favor, comparta su conocimiento para que futuros usuarios puedan beneficiarse. Gracias. | Murcia, mayo de 2024 | SERVICIO DE URBANISMO | https://www.urbmurcia.es/web/urbmurcia/contacto | -->
<sld:StyledLayerDescriptor xmlns="http://www.opengis.net/sld" xmlns:sld="http://www.opengis.net/sld" xmlns:gml="http://www.opengis.net/gml" xmlns:ogc="http://www.opengis.net/ogc" version="1.0.0">
	<sld:NamedLayer>
		<sld:Name>23_usos_pormenorizados</sld:Name>
		<sld:UserStyle>
			<sld:Name>23_usos_pormenorizados</sld:Name>
			<sld:FeatureTypeStyle>
				<sld:Name>linea</sld:Name>
				<sld:Title>Usos pormenorizados</sld:Title>
				<sld:Abstract/>
				<sld:Rule>
					<sld:Name>Residencial</sld:Name>
					<sld:Title>Residencial (RU, RC, RT)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Uso</ogc:PropertyName>
							<ogc:Literal>R%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#FF5050</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">1.5 2.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>Residencial protegido</sld:Name>
					<sld:Title>Residencial protegido (RP)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsEqualTo>
							<ogc:PropertyName>Uso</ogc:PropertyName>
							<ogc:Literal>RP</ogc:Literal>
						</ogc:PropertyIsEqualTo>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#50FFC8</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">1.5 2.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>Industrial</sld:Name>
					<sld:Title>Industrial (IM, IP, IE)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Uso</ogc:PropertyName>
							<ogc:Literal>I%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#FF5050</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">1.5 2.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>Terciario</sld:Name>
					<sld:Title>Terciario (TC, TG, TH, TL, TO, TV)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Uso</ogc:PropertyName>
							<ogc:Literal>T%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:LineSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom2</ogc:PropertyName>
						</sld:Geometry>
						<sld:Stroke>
							<sld:CssParameter name="stroke">#FF5050</sld:CssParameter>
							<sld:CssParameter name="stroke-dasharray">1.5 2.0</sld:CssParameter>
						</sld:Stroke>
						<sld:PerpendicularOffset>0.0</sld:PerpendicularOffset>
					</sld:LineSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
			<sld:FeatureTypeStyle>
				<sld:Name>poligono</sld:Name>
				<sld:Title/>
				<sld:Abstract/>
				<sld:Rule>
					<sld:Name>poligono residencial</sld:Name>
					<sld:Title>Residencial (RU, RC, RT)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Uso</ogc:PropertyName>
							<ogc:Literal>R%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
						<sld:Fill>
							<sld:CssParameter name="fill">#F07864</sld:CssParameter>
							<sld:CssParameter name="fill-opacity">0.75</sld:CssParameter>
						</sld:Fill>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>poligono residencial protegido</sld:Name>
					<sld:Title>Residencial protegido (RP)</sld:Title>
					<sld:Abstract/>
					<ogc:PropertyIsEqualTo>
						<ogc:PropertyName>Uso</ogc:PropertyName>
						<ogc:Literal>RP</ogc:Literal>
					</ogc:PropertyIsEqualTo>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
						<sld:Fill>
							<sld:CssParameter name="fill">#F07864</sld:CssParameter>
							<sld:CssParameter name="fill-opacity">0.75</sld:CssParameter>
						</sld:Fill>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>poligono industrial</sld:Name>
					<sld:Title>Industrial (IM, IP, IE)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Uso</ogc:PropertyName>
							<ogc:Literal>I%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
						<sld:Fill>
							<sld:CssParameter name="fill">#646464</sld:CssParameter>
							<sld:CssParameter name="fill-opacity">0.75</sld:CssParameter>
						</sld:Fill>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>poligono terciario</sld:Name>
					<sld:Title>Terciario (TC, TG, TH, TL, TO, TV)</sld:Title>
					<sld:Abstract/>
					<ogc:Filter>
						<ogc:PropertyIsLike wildCard="%" singleChar="_" escape="\">
							<ogc:PropertyName>Uso</ogc:PropertyName>
							<ogc:Literal>T%</ogc:Literal>
						</ogc:PropertyIsLike>
					</ogc:Filter>
					<sld:PolygonSymbolizer>
						<sld:Geometry>
							<ogc:PropertyName>geom</ogc:PropertyName>
						</sld:Geometry>
						<sld:Fill>
							<sld:CssParameter name="fill">#969696</sld:CssParameter>
							<sld:CssParameter name="fill-opacity">0.75</sld:CssParameter>
						</sld:Fill>
					</sld:PolygonSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>etiqueta_sup</sld:Name>
					<sld:Title/>
					<sld:Abstract/>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Calificación</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">12</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">bold</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.0</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>5.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#000000</sld:CssParameter>
						</sld:Fill>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>Grafico</sld:Name>
					<sld:Title/>
					<sld:Abstract/>
					<sld:TextSymbolizer>
						<sld:Label>·</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">5</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>0.5</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>0.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#000000</sld:CssParameter>
						</sld:Fill>
						<sld:Graphic>
							<sld:ExternalGraphic>
								<sld:OnlineResource xmlns:xlink="http://www.w3.org/1999/xlink" xlink:type="simple" xlink:href="file:disco.svg"/>
								<sld:Format>image/svg+xml</sld:Format>
							</sld:ExternalGraphic>
							<sld:Opacity>0.5</sld:Opacity>
							<sld:Size>35.0</sld:Size>
						</sld:Graphic>
						<sld:VendorOption name="allowOverruns">false</sld:VendorOption>
						<sld:VendorOption name="conflictResolution">false</sld:VendorOption>
						<sld:VendorOption name="forceLeftToRight">false</sld:VendorOption>
					</sld:TextSymbolizer>
				</sld:Rule>
				<sld:Rule>
					<sld:Name>etiqueta_inf</sld:Name>
					<sld:Title/>
					<sld:Abstract/>
					<sld:TextSymbolizer>
						<sld:Label>
							<ogc:PropertyName>Altura_máxima</ogc:PropertyName>
						</sld:Label>
						<sld:Font>
							<sld:CssParameter name="font-family">Liberation Mono</sld:CssParameter>
							<sld:CssParameter name="font-size">12</sld:CssParameter>
							<sld:CssParameter name="font-style">normal</sld:CssParameter>
							<sld:CssParameter name="font-weight">normal</sld:CssParameter>
						</sld:Font>
						<sld:LabelPlacement>
							<sld:PointPlacement>
								<sld:AnchorPoint>
									<sld:AnchorPointX>0.5</sld:AnchorPointX>
									<sld:AnchorPointY>1.0</sld:AnchorPointY>
								</sld:AnchorPoint>
								<sld:Displacement>
									<sld:DisplacementX>0.0</sld:DisplacementX>
									<sld:DisplacementY>-2.0</sld:DisplacementY>
								</sld:Displacement>
							</sld:PointPlacement>
						</sld:LabelPlacement>
						<sld:Fill>
							<sld:CssParameter name="fill">#000000</sld:CssParameter>
						</sld:Fill>
					</sld:TextSymbolizer>
				</sld:Rule>
			</sld:FeatureTypeStyle>
		</sld:UserStyle>
	</sld:NamedLayer>
</sld:StyledLayerDescriptor>
